# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdpackage import SDPackage
from .sdarray import SDArray
from .sdapiobject import SDAPIObject
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDPackageMgr(SDAPIObject):
    """
    Provides functions to create, list, load and save SDPackage. There is only one SDPackageMgr, that you can retrieve from the SDApplication
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDPackageMgr
        """
        super(SDPackageMgr, self).__init__(APIContext, handle, *args, **kwargs)

    def newUserPackage(self) -> Optional[SDPackage]:
        """
        Create a new user package

        """
        outPackage = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackageMgr_newUserPackage(self.mHandle, ctypes.byref(outPackage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outPackage, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outPackage.value, ownHandle=True)

    def loadUserPackage(self, sdPackageFileAbsPath : str, updatePackages : bool = True, reloadIfModified : bool = True) -> Optional[SDPackage]:
        """
        Load a package from its file path

        :param sdPackageFileAbsPath: The absolute file path of the package to load
        :param updatePackages: If True then packages will be updated if needed.
        :param reloadIfModified: If True then packages will be reloaded if modified.
        """
        outPackage = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackageMgr_loadUserPackage(self.mHandle, ctypes.create_string_buffer(sdPackageFileAbsPath.encode('utf-8')), updatePackages, reloadIfModified, ctypes.byref(outPackage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outPackage, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outPackage.value, ownHandle=True)

    def unloadUserPackage(self, sdPackage : SDPackage) -> None:
        """
        Unload the specified package

        :param sdPackage: The package to unload
        """
        _res = self.mAPIContext.SDPackageMgr_unloadUserPackage(self.mHandle, sdPackage.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getUserPackageFromFilePath(self, sdPackageFileAbsPath : str) -> Optional[SDPackage]:
        """
        Get the user package from its file path. The package must have been previously loaded using 'loadUserPackage'

        :param sdPackageFileAbsPath: The absolute file path of the package to find
        """
        outPackage = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackageMgr_getUserPackageFromFilePath(self.mHandle, ctypes.create_string_buffer(sdPackageFileAbsPath.encode('utf-8')), ctypes.byref(outPackage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outPackage, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outPackage.value, ownHandle=True)

    def getUserPackages(self) -> SDArray[SDPackage]:
        """
        Returns the list of all loaded user packages

        """
        outPackageArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackageMgr_getUserPackages(self.mHandle, ctypes.byref(outPackageArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outPackageArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outPackageArray.value, ownHandle=True)

    def getPackages(self) -> SDArray[SDPackage]:
        """
        Returns the list of all loaded packages

        """
        outPackageArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackageMgr_getPackages(self.mHandle, ctypes.byref(outPackageArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outPackageArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outPackageArray.value, ownHandle=True)

    def savePackageAs(self, sdPackage : SDPackage, fileAbsPath : str) -> None:
        """
        Save the specified package to the specified location

        :param sdPackage: The package to save
        :param fileAbsPath: The absolute file path used to save the package
        """
        _res = self.mAPIContext.SDPackageMgr_savePackageAs(self.mHandle, sdPackage.mHandle, ctypes.create_string_buffer(fileAbsPath.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def savePackage(self, sdPackage : SDPackage) -> None:
        """
        Save the specified package if it was saved before. Otherwise, it raises an exception

        :param sdPackage: The package to save
        """
        _res = self.mAPIContext.SDPackageMgr_savePackage(self.mHandle, sdPackage.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def saveCopyOfPackageAs(self, sdPackage : SDPackage, fileAbsPath : str) -> None:
        """
        Save a copy of the specified package to the specified location

        :param sdPackage: The package to save
        :param fileAbsPath: The absolute file path used to save the package
        """
        _res = self.mAPIContext.SDPackageMgr_saveCopyOfPackageAs(self.mHandle, sdPackage.mHandle, ctypes.create_string_buffer(fileAbsPath.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

